/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.mehvahdjukaar.amendments.common.block.LiquidCauldronBlock;
import net.mehvahdjukaar.amendments.common.block.ModCauldronBlock;
import net.mehvahdjukaar.amendments.common.recipe.DummyContainer;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.events.behaviors.CauldronConversion;
import net.mehvahdjukaar.amendments.reg.ModBlockProperties;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;

public class BoilingWaterCauldronBlock
extends LayeredCauldronBlock {
    public static final BooleanProperty BOILING = ModBlockProperties.BOILING;

    public BoilingWaterCauldronBlock(BlockBehaviour.Properties properties, Predicate<Biome.Precipitation> fillPredicate, Map<Item, CauldronInteraction> interactions) {
        super(properties, fillPredicate, interactions);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BOILING, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BOILING});
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.m_7892_(state, level, pos, entity);
        if (!level.f_46443_ && this.m_151979_(state, pos, entity)) {
            if (((Boolean)state.m_61143_((Property)BOILING)).booleanValue() && entity instanceof LivingEntity) {
                entity.m_6469_(new DamageSource(ModRegistry.BOILING_DAMAGE.getHolder()), 1.0f);
            }
            if (entity.m_6060_()) {
                LiquidCauldronBlock.playExtinguishSound(level, pos, entity);
            }
            this.attemptStewCrafting(state, level, pos, entity);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        BlockState s = super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
        if (direction == Direction.DOWN) {
            boolean isFire = LiquidCauldronBlock.shouldBoil(neighborState, SoftFluidStack.of((Holder)BuiltInSoftFluids.WATER.getHolder()), level, neighborPos);
            s = (BlockState)s.m_61124_((Property)BOILING, (Comparable)Boolean.valueOf(isFire));
        }
        return s;
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (this.m_151979_(state, pos, entity)) {
            if (!level.f_46443_) {
                ModCauldronBlock.playSplashEffects(entity, this.m_142446_(state));
            }
            super.m_142072_(level, state, pos, entity, 0.0f);
        } else {
            super.m_142072_(level, state, pos, entity, fallDistance);
        }
    }

    public static int getWaterColor(BlockState state, BlockAndTintGetter level, BlockPos pos, int i) {
        return i == 1 && level != null && pos != null ? BiomeColors.m_108811_((BlockAndTintGetter)level, (BlockPos)pos) : -1;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.m_214162_(state, level, pos, random);
        if (((Boolean)state.m_61143_((Property)BOILING)).booleanValue()) {
            LiquidCauldronBlock.playBubblingAnimation(level, pos, this.m_142446_(state), random, BoilingWaterCauldronBlock.getWaterColor(state, (BlockAndTintGetter)level, pos, 1), 0);
        }
    }

    private void attemptStewCrafting(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!((Boolean)state.m_61143_((Property)BOILING)).booleanValue() || !(entity instanceof ItemEntity) || entity.f_19797_ % 10 != 0) {
            return;
        }
        List entities = level.m_45976_(ItemEntity.class, new AABB((double)pos.m_123341_() + 0.125, (double)((float)pos.m_123342_() + 0.375f), (double)pos.m_123343_() + 0.125, (double)pos.m_123341_() + 0.875, (double)pos.m_123342_() + this.m_142446_(state), (double)pos.m_123343_() + 0.875));
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        for (ItemEntity e : entities) {
            ItemStack i = e.m_32055_();
            for (int c = 0; c < i.m_41613_(); ++c) {
                ingredients.add(i.m_255036_(1));
            }
        }
        ingredients.add(Items.f_42399_.m_7968_());
        DummyContainer container = DummyContainer.of(ingredients);
        List recipes = level.m_7465_().m_44056_(RecipeType.f_44107_, (Container)container, level);
        for (CraftingRecipe r : recipes) {
            BlockState newState;
            Pair fluid;
            ItemStack result = r.m_5874_((Container)container, level.m_9598_());
            if (result.m_41619_() || (fluid = SoftFluidStack.fromItem((ItemStack)result)) == null || (newState = CauldronConversion.getNewState(pos, level, (SoftFluidStack)fluid.getFirst())) == null) continue;
            level.m_46597_(pos, newState);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof LiquidCauldronBlockTile) {
                LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
                int lev = (Integer)state.m_61143_((Property)f_153514_);
                int newLev = lev == 3 ? te.getSoftFluidTank().getCapacity() : lev;
                te.getSoftFluidTank().setFluid(((SoftFluidStack)fluid.getFirst()).copyWithCount(newLev));
                te.m_6596_();
                level.m_142346_(entity, GameEvent.f_157792_, pos);
                level.m_5594_(null, pos, SoundEvents.f_11772_, SoundSource.BLOCKS, 0.9f, 0.6f);
            }
            BoilingWaterCauldronBlock.clearUsedIngredients(entities, ingredients);
        }
    }

    private static void clearUsedIngredients(List<ItemEntity> entities, List<ItemStack> ingredients) {
        for (ItemStack v : ingredients) {
            Iterator<ItemEntity> iter = entities.iterator();
            while (iter.hasNext()) {
                ItemEntity e = iter.next();
                ItemStack itemEntityItem = e.m_32055_();
                if (!ItemStack.m_150942_((ItemStack)itemEntityItem, (ItemStack)v)) continue;
                itemEntityItem.m_41774_(1);
                if (!itemEntityItem.m_41619_()) continue;
                e.m_146870_();
                iter.remove();
            }
        }
    }
}

